@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getCapacityBlockOffering.
 * @property availabilityZone The Availability Zone in which to create the Capacity Reservation.
 * @property capacityBlockOfferingId The Capacity Block Reservation ID.
 * @property capacityDurationHours
 * @property currencyCode The currency of the payment for the Capacity Block.
 * @property endDateRange
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceCount
 * @property instanceType
 * @property startDateRange
 * @property tenancy Indicates the tenancy of the Capacity Reservation. Specify either `default` or `dedicated`.
 * @property upfrontFee The total price to be paid up front.
 */
public data class GetCapacityBlockOfferingResult(
    public val availabilityZone: String,
    public val capacityBlockOfferingId: String,
    public val capacityDurationHours: Int,
    public val currencyCode: String,
    public val endDateRange: String,
    public val id: String,
    public val instanceCount: Int,
    public val instanceType: String,
    public val startDateRange: String,
    public val tenancy: String,
    public val upfrontFee: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetCapacityBlockOfferingResult): GetCapacityBlockOfferingResult = GetCapacityBlockOfferingResult(
            availabilityZone = javaType.availabilityZone(),
            capacityBlockOfferingId = javaType.capacityBlockOfferingId(),
            capacityDurationHours = javaType.capacityDurationHours(),
            currencyCode = javaType.currencyCode(),
            endDateRange = javaType.endDateRange(),
            id = javaType.id(),
            instanceCount = javaType.instanceCount(),
            instanceType = javaType.instanceType(),
            startDateRange = javaType.startDateRange(),
            tenancy = javaType.tenancy(),
            upfrontFee = javaType.upfrontFee(),
        )
    }
}
