@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCoipPool.
 * @property arn ARN of the COIP pool
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property localGatewayRouteTableId
 * @property poolCidrs Set of CIDR blocks in pool
 * @property poolId
 * @property tags
 */
public data class GetCoipPoolResult(
    public val arn: String,
    public val filters: List<GetCoipPoolFilter>? = null,
    public val id: String,
    public val localGatewayRouteTableId: String,
    public val poolCidrs: List<String>,
    public val poolId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetCoipPoolResult): GetCoipPoolResult =
            GetCoipPoolResult(
                arn = javaType.arn(),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetCoipPoolFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                localGatewayRouteTableId = javaType.localGatewayRouteTableId(),
                poolCidrs = javaType.poolCidrs().map({ args0 -> args0 }),
                poolId = javaType.poolId(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
