@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCoipPools.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property poolIds Set of COIP Pool Identifiers
 * @property tags
 */
public data class GetCoipPoolsResult(
    public val filters: List<GetCoipPoolsFilter>? = null,
    public val id: String,
    public val poolIds: List<String>,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetCoipPoolsResult): GetCoipPoolsResult = GetCoipPoolsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetCoipPoolsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            poolIds = javaType.poolIds().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
