@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDedicatedHost.
 * @property arn ARN of the Dedicated Host.
 * @property assetId The ID of the Outpost hardware asset on which the Dedicated Host is allocated.
 * @property autoPlacement Whether auto-placement is on or off.
 * @property availabilityZone Availability Zone of the Dedicated Host.
 * @property cores Number of cores on the Dedicated Host.
 * @property filters
 * @property hostId
 * @property hostRecovery Whether host recovery is enabled or disabled for the Dedicated Host.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceFamily Instance family supported by the Dedicated Host. For example, "m5".
 * @property instanceType Instance type supported by the Dedicated Host. For example, "m5.large". If the host supports multiple instance types, no instanceType is returned.
 * @property outpostArn ARN of the AWS Outpost on which the Dedicated Host is allocated.
 * @property ownerId ID of the AWS account that owns the Dedicated Host.
 * @property sockets Number of sockets on the Dedicated Host.
 * @property tags
 * @property totalVcpus Total number of vCPUs on the Dedicated Host.
 */
public data class GetDedicatedHostResult(
    public val arn: String,
    public val assetId: String,
    public val autoPlacement: String,
    public val availabilityZone: String,
    public val cores: Int,
    public val filters: List<GetDedicatedHostFilter>? = null,
    public val hostId: String,
    public val hostRecovery: String,
    public val id: String,
    public val instanceFamily: String,
    public val instanceType: String,
    public val outpostArn: String,
    public val ownerId: String,
    public val sockets: Int,
    public val tags: Map<String, String>,
    public val totalVcpus: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetDedicatedHostResult): GetDedicatedHostResult = GetDedicatedHostResult(
            arn = javaType.arn(),
            assetId = javaType.assetId(),
            autoPlacement = javaType.autoPlacement(),
            availabilityZone = javaType.availabilityZone(),
            cores = javaType.cores(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetDedicatedHostFilter.Companion.toKotlin(args0)
                })
            }),
            hostId = javaType.hostId(),
            hostRecovery = javaType.hostRecovery(),
            id = javaType.id(),
            instanceFamily = javaType.instanceFamily(),
            instanceType = javaType.instanceType(),
            outpostArn = javaType.outpostArn(),
            ownerId = javaType.ownerId(),
            sockets = javaType.sockets(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalVcpus = javaType.totalVcpus(),
        )
    }
}
