@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property deleteOnTermination If the root block device will be deleted on termination.
 * @property deviceName Physical name of the device.
 * @property encrypted If the EBS volume is encrypted.
 * @property iops `0` If the volume is not a provisioned IOPS image, otherwise the supported IOPS count.
 * @property kmsKeyId
 * @property snapshotId ID of the snapshot.
 * @property tags Map of tags assigned to the Instance.
 * @property throughput Throughput of the volume, in MiB/s.
 * @property volumeId
 * @property volumeSize Size of the volume, in GiB.
 * @property volumeType Type of the volume.
 */
public data class GetInstanceEbsBlockDevice(
    public val deleteOnTermination: Boolean,
    public val deviceName: String,
    public val encrypted: Boolean,
    public val iops: Int,
    public val kmsKeyId: String,
    public val snapshotId: String,
    public val tags: Map<String, String>,
    public val throughput: Int,
    public val volumeId: String,
    public val volumeSize: Int,
    public val volumeType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstanceEbsBlockDevice): GetInstanceEbsBlockDevice = GetInstanceEbsBlockDevice(
            deleteOnTermination = javaType.deleteOnTermination(),
            deviceName = javaType.deviceName(),
            encrypted = javaType.encrypted(),
            iops = javaType.iops(),
            kmsKeyId = javaType.kmsKeyId(),
            snapshotId = javaType.snapshotId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            throughput = javaType.throughput(),
            volumeId = javaType.volumeId(),
            volumeSize = javaType.volumeSize(),
            volumeType = javaType.volumeType(),
        )
    }
}
