@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInstance.
 * @property ami ID of the AMI used to launch the instance.
 * @property arn ARN of the instance.
 * @property associatePublicIpAddress Whether or not the Instance is associated with a public IP address or not (Boolean).
 * @property availabilityZone Availability zone of the Instance.
 * @property creditSpecifications Credit specification of the Instance.
 * @property disableApiStop Whether or not EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection) is enabled (Boolean).
 * @property disableApiTermination Whether or not [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination) is enabled (Boolean).
 * @property ebsBlockDevices EBS block device mappings of the Instance.
 * @property ebsOptimized Whether the Instance is EBS optimized or not (Boolean).
 * @property enclaveOptions Enclave options of the instance.
 * @property ephemeralBlockDevices Ephemeral block device mappings of the Instance.
 * @property filters
 * @property getPasswordData
 * @property getUserData
 * @property hostId ID of the dedicated host the instance will be assigned to.
 * @property hostResourceGroupArn ARN of the host resource group the instance is associated with.
 * @property iamInstanceProfile Name of the instance profile associated with the Instance.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property instanceState State of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
 * @property instanceTags
 * @property instanceType Type of the Instance.
 * @property ipv6Addresses IPv6 addresses associated to the Instance, if applicable. **NOTE**: Unlike the IPv4 address, this doesn't change if you attach an EIP to the instance.
 * @property keyName Key name of the Instance.
 * @property launchTime Time the instance was launched.
 * @property maintenanceOptions Maintenance and recovery options for the instance.
 * @property metadataOptions Metadata options of the Instance.
 * @property monitoring Whether detailed monitoring is enabled or disabled for the Instance (Boolean).
 * @property networkInterfaceId ID of the network interface that was created with the Instance.
 * @property outpostArn ARN of the Outpost.
 * @property passwordData Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
 * @property placementGroup Placement group of the Instance.
 * @property placementPartitionNumber Number of the partition the instance is in.
 * @property privateDns Private DNS name assigned to the Instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
 * @property privateDnsNameOptions Options for the instance hostname.
 * @property privateIp Private IP address assigned to the Instance.
 * @property publicDns Public DNS name assigned to the Instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
 * @property publicIp Public IP address assigned to the Instance, if applicable. **NOTE**: If you are using an `aws.ec2.Eip` with your instance, you should refer to the EIP's address directly and not use `public_ip`, as this field will change after the EIP is attached.
 * @property rootBlockDevices Root block device mappings of the Instance
 * @property secondaryPrivateIps Secondary private IPv4 addresses assigned to the instance's primary network interface (eth0) in a VPC.
 * @property securityGroups Associated security groups.
 * @property sourceDestCheck Whether the network interface performs source/destination checking (Boolean).
 * @property subnetId VPC subnet ID.
 * @property tags Map of tags assigned to the Instance.
 * @property tenancy Tenancy of the instance: `dedicated`, `default`, `host`.
 * @property userData SHA-1 hash of User Data supplied to the Instance.
 * @property userDataBase64 Base64 encoded contents of User Data supplied to the Instance. This attribute is only exported if `get_user_data` is true.
 * @property vpcSecurityGroupIds Associated security groups in a non-default VPC.
 */
public data class GetInstanceResult(
    public val ami: String,
    public val arn: String,
    public val associatePublicIpAddress: Boolean,
    public val availabilityZone: String,
    public val creditSpecifications: List<GetInstanceCreditSpecification>,
    public val disableApiStop: Boolean,
    public val disableApiTermination: Boolean,
    public val ebsBlockDevices: List<GetInstanceEbsBlockDevice>,
    public val ebsOptimized: Boolean,
    public val enclaveOptions: List<GetInstanceEnclaveOption>,
    public val ephemeralBlockDevices: List<GetInstanceEphemeralBlockDevice>,
    public val filters: List<GetInstanceFilter>? = null,
    public val getPasswordData: Boolean? = null,
    public val getUserData: Boolean? = null,
    public val hostId: String,
    public val hostResourceGroupArn: String,
    public val iamInstanceProfile: String,
    public val id: String,
    public val instanceId: String? = null,
    public val instanceState: String,
    public val instanceTags: Map<String, String>,
    public val instanceType: String,
    public val ipv6Addresses: List<String>,
    public val keyName: String,
    public val launchTime: String,
    public val maintenanceOptions: List<GetInstanceMaintenanceOption>,
    public val metadataOptions: List<GetInstanceMetadataOption>,
    public val monitoring: Boolean,
    public val networkInterfaceId: String,
    public val outpostArn: String,
    public val passwordData: String,
    public val placementGroup: String,
    public val placementPartitionNumber: Int,
    public val privateDns: String,
    public val privateDnsNameOptions: List<GetInstancePrivateDnsNameOption>,
    public val privateIp: String,
    public val publicDns: String,
    public val publicIp: String,
    public val rootBlockDevices: List<GetInstanceRootBlockDevice>,
    public val secondaryPrivateIps: List<String>,
    public val securityGroups: List<String>,
    public val sourceDestCheck: Boolean,
    public val subnetId: String,
    public val tags: Map<String, String>,
    public val tenancy: String,
    public val userData: String,
    public val userDataBase64: String,
    public val vpcSecurityGroupIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstanceResult): GetInstanceResult =
            GetInstanceResult(
                ami = javaType.ami(),
                arn = javaType.arn(),
                associatePublicIpAddress = javaType.associatePublicIpAddress(),
                availabilityZone = javaType.availabilityZone(),
                creditSpecifications = javaType.creditSpecifications().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetInstanceCreditSpecification.Companion.toKotlin(args0)
                    })
                }),
                disableApiStop = javaType.disableApiStop(),
                disableApiTermination = javaType.disableApiTermination(),
                ebsBlockDevices = javaType.ebsBlockDevices().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetInstanceEbsBlockDevice.Companion.toKotlin(args0)
                    })
                }),
                ebsOptimized = javaType.ebsOptimized(),
                enclaveOptions = javaType.enclaveOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetInstanceEnclaveOption.Companion.toKotlin(args0)
                    })
                }),
                ephemeralBlockDevices = javaType.ephemeralBlockDevices().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetInstanceEphemeralBlockDevice.Companion.toKotlin(args0)
                    })
                }),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetInstanceFilter.Companion.toKotlin(args0)
                    })
                }),
                getPasswordData = javaType.getPasswordData().map({ args0 -> args0 }).orElse(null),
                getUserData = javaType.getUserData().map({ args0 -> args0 }).orElse(null),
                hostId = javaType.hostId(),
                hostResourceGroupArn = javaType.hostResourceGroupArn(),
                iamInstanceProfile = javaType.iamInstanceProfile(),
                id = javaType.id(),
                instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
                instanceState = javaType.instanceState(),
                instanceTags = javaType.instanceTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                instanceType = javaType.instanceType(),
                ipv6Addresses = javaType.ipv6Addresses().map({ args0 -> args0 }),
                keyName = javaType.keyName(),
                launchTime = javaType.launchTime(),
                maintenanceOptions = javaType.maintenanceOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetInstanceMaintenanceOption.Companion.toKotlin(args0)
                    })
                }),
                metadataOptions = javaType.metadataOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetInstanceMetadataOption.Companion.toKotlin(args0)
                    })
                }),
                monitoring = javaType.monitoring(),
                networkInterfaceId = javaType.networkInterfaceId(),
                outpostArn = javaType.outpostArn(),
                passwordData = javaType.passwordData(),
                placementGroup = javaType.placementGroup(),
                placementPartitionNumber = javaType.placementPartitionNumber(),
                privateDns = javaType.privateDns(),
                privateDnsNameOptions = javaType.privateDnsNameOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetInstancePrivateDnsNameOption.Companion.toKotlin(args0)
                    })
                }),
                privateIp = javaType.privateIp(),
                publicDns = javaType.publicDns(),
                publicIp = javaType.publicIp(),
                rootBlockDevices = javaType.rootBlockDevices().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetInstanceRootBlockDevice.Companion.toKotlin(args0)
                    })
                }),
                secondaryPrivateIps = javaType.secondaryPrivateIps().map({ args0 -> args0 }),
                securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
                sourceDestCheck = javaType.sourceDestCheck(),
                subnetId = javaType.subnetId(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                tenancy = javaType.tenancy(),
                userData = javaType.userData(),
                userDataBase64 = javaType.userDataBase64(),
                vpcSecurityGroupIds = javaType.vpcSecurityGroupIds().map({ args0 -> args0 }),
            )
    }
}
