@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceTypeOffering.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceType EC2 Instance Type.
 * @property locationType
 * @property preferredInstanceTypes
 */
public data class GetInstanceTypeOfferingResult(
    public val filters: List<GetInstanceTypeOfferingFilter>? = null,
    public val id: String,
    public val instanceType: String,
    public val locationType: String? = null,
    public val preferredInstanceTypes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstanceTypeOfferingResult): GetInstanceTypeOfferingResult = GetInstanceTypeOfferingResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeOfferingFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceType = javaType.instanceType(),
            locationType = javaType.locationType().map({ args0 -> args0 }).orElse(null),
            preferredInstanceTypes = javaType.preferredInstanceTypes().map({ args0 -> args0 }),
        )
    }
}
