@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the filter. The `location` filter depends on the top-level `location_type` argument and if not specified, defaults to the current region.
 * @property values List of one or more values for the filter.
 */
public data class GetInstanceTypeOfferingsFilter(
    public val name: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstanceTypeOfferingsFilter): GetInstanceTypeOfferingsFilter = GetInstanceTypeOfferingsFilter(
            name = javaType.name(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
