@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInstances.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids IDs of instances found through the filter
 * @property instanceStateNames
 * @property instanceTags
 * @property ipv6Addresses IPv6 addresses of instances found through the filter
 * @property privateIps Private IP addresses of instances found through the filter
 * @property publicIps Public IP addresses of instances found through the filter
 */
public data class GetInstancesResult(
    public val filters: List<GetInstancesFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceStateNames: List<String>? = null,
    public val instanceTags: Map<String, String>,
    public val ipv6Addresses: List<String>,
    public val privateIps: List<String>,
    public val publicIps: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetInstancesFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceStateNames = javaType.instanceStateNames().map({ args0 -> args0 }),
            instanceTags = javaType.instanceTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            ipv6Addresses = javaType.ipv6Addresses().map({ args0 -> args0 }),
            privateIps = javaType.privateIps().map({ args0 -> args0 }),
            publicIps = javaType.publicIps().map({ args0 -> args0 }),
        )
    }
}
