@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInternetGateway.
 * @property arn ARN of the Internet Gateway.
 * @property attachments
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property internetGatewayId
 * @property ownerId ID of the AWS account that owns the internet gateway.
 * @property tags
 */
public data class GetInternetGatewayResult(
    public val arn: String,
    public val attachments: List<GetInternetGatewayAttachment>,
    public val filters: List<GetInternetGatewayFilter>? = null,
    public val id: String,
    public val internetGatewayId: String,
    public val ownerId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInternetGatewayResult): GetInternetGatewayResult = GetInternetGatewayResult(
            arn = javaType.arn(),
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetInternetGatewayAttachment.Companion.toKotlin(args0)
                })
            }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetInternetGatewayFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            internetGatewayId = javaType.internetGatewayId(),
            ownerId = javaType.ownerId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
