@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIpamPreviewNextCidr.
 * @property cidr Previewed CIDR from the pool.
 * @property disallowedCidrs
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipamPoolId
 * @property netmaskLength
 */
public data class GetIpamPreviewNextCidrResult(
    public val cidr: String,
    public val disallowedCidrs: List<String>? = null,
    public val id: String,
    public val ipamPoolId: String,
    public val netmaskLength: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetIpamPreviewNextCidrResult): GetIpamPreviewNextCidrResult = GetIpamPreviewNextCidrResult(
            cidr = javaType.cidr(),
            disallowedCidrs = javaType.disallowedCidrs().map({ args0 -> args0 }),
            id = javaType.id(),
            ipamPoolId = javaType.ipamPoolId(),
            netmaskLength = javaType.netmaskLength().map({ args0 -> args0 }).orElse(null),
        )
    }
}
