@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getKeyPair.
 * @property arn ARN of the Key Pair.
 * @property createTime Timestamp for when the key pair was created in ISO 8601 format.
 * @property filters
 * @property fingerprint SHA-1 digest of the DER encoded private key.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property includePublicKey
 * @property keyName
 * @property keyPairId
 * @property keyType Type of key pair.
 * @property publicKey Public key material.
 * @property tags Any tags assigned to the Key Pair.
 */
public data class GetKeyPairResult(
    public val arn: String,
    public val createTime: String,
    public val filters: List<GetKeyPairFilter>? = null,
    public val fingerprint: String,
    public val id: String,
    public val includePublicKey: Boolean? = null,
    public val keyName: String? = null,
    public val keyPairId: String? = null,
    public val keyType: String,
    public val publicKey: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetKeyPairResult): GetKeyPairResult =
            GetKeyPairResult(
                arn = javaType.arn(),
                createTime = javaType.createTime(),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetKeyPairFilter.Companion.toKotlin(args0)
                    })
                }),
                fingerprint = javaType.fingerprint(),
                id = javaType.id(),
                includePublicKey = javaType.includePublicKey().map({ args0 -> args0 }).orElse(null),
                keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
                keyPairId = javaType.keyPairId().map({ args0 -> args0 }).orElse(null),
                keyType = javaType.keyType(),
                publicKey = javaType.publicKey(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
