@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteOnTermination Whether the EBS Volume will be deleted on instance termination.
 * @property deviceName Name of the device.
 * @property encrypted Whether the volume is Encrypted.
 * @property iops Provisioned IOPs of the volume.
 * @property noDevice Whether the device in the block device mapping of the AMI is suppressed.
 * @property snapshotId Snapshot ID of the mount.
 * @property throughput Throughput of the volume.
 * @property volumeSize Size of the volume.
 * @property volumeType Type of the volume.
 */
public data class GetLaunchConfigurationEbsBlockDevice(
    public val deleteOnTermination: Boolean,
    public val deviceName: String,
    public val encrypted: Boolean,
    public val iops: Int,
    public val noDevice: Boolean,
    public val snapshotId: String,
    public val throughput: Int,
    public val volumeSize: Int,
    public val volumeType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchConfigurationEbsBlockDevice): GetLaunchConfigurationEbsBlockDevice = GetLaunchConfigurationEbsBlockDevice(
            deleteOnTermination = javaType.deleteOnTermination(),
            deviceName = javaType.deviceName(),
            encrypted = javaType.encrypted(),
            iops = javaType.iops(),
            noDevice = javaType.noDevice(),
            snapshotId = javaType.snapshotId(),
            throughput = javaType.throughput(),
            volumeSize = javaType.volumeSize(),
            volumeType = javaType.volumeType(),
        )
    }
}
