@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpEndpoint State of the metadata service: `enabled`, `disabled`.
 * @property httpPutResponseHopLimit The desired HTTP PUT response hop limit for instance metadata requests.
 * @property httpTokens If session tokens are required: `optional`, `required`.
 */
public data class GetLaunchConfigurationMetadataOption(
    public val httpEndpoint: String,
    public val httpPutResponseHopLimit: Int,
    public val httpTokens: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchConfigurationMetadataOption): GetLaunchConfigurationMetadataOption = GetLaunchConfigurationMetadataOption(
            httpEndpoint = javaType.httpEndpoint(),
            httpPutResponseHopLimit = javaType.httpPutResponseHopLimit(),
            httpTokens = javaType.httpTokens(),
        )
    }
}
