@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLaunchConfiguration.
 * @property arn Amazon Resource Name of the launch configuration.
 * @property associatePublicIpAddress Whether a Public IP address is associated with the instance.
 * @property ebsBlockDevices EBS Block Devices attached to the instance.
 * @property ebsOptimized Whether the launched EC2 instance will be EBS-optimized.
 * @property enableMonitoring Whether Detailed Monitoring is Enabled.
 * @property ephemeralBlockDevices The Ephemeral volumes on the instance.
 * @property iamInstanceProfile The IAM Instance Profile to associate with launched instances.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageId EC2 Image ID of the instance.
 * @property instanceType Instance Type of the instance to launch.
 * @property keyName Key Name that should be used for the instance.
 * @property metadataOptions Metadata options for the instance.
 * @property name Name of the launch configuration.
 * @property placementTenancy Tenancy of the instance.
 * @property rootBlockDevices Root Block Device of the instance.
 * @property securityGroups List of associated Security Group IDS.
 * @property spotPrice Price to use for reserving Spot instances.
 * @property userData User Data of the instance.
 */
public data class GetLaunchConfigurationResult(
    public val arn: String,
    public val associatePublicIpAddress: Boolean,
    public val ebsBlockDevices: List<GetLaunchConfigurationEbsBlockDevice>,
    public val ebsOptimized: Boolean,
    public val enableMonitoring: Boolean,
    public val ephemeralBlockDevices: List<GetLaunchConfigurationEphemeralBlockDevice>,
    public val iamInstanceProfile: String,
    public val id: String,
    public val imageId: String,
    public val instanceType: String,
    public val keyName: String,
    public val metadataOptions: List<GetLaunchConfigurationMetadataOption>,
    public val name: String,
    public val placementTenancy: String,
    public val rootBlockDevices: List<GetLaunchConfigurationRootBlockDevice>,
    public val securityGroups: List<String>,
    public val spotPrice: String,
    public val userData: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchConfigurationResult): GetLaunchConfigurationResult = GetLaunchConfigurationResult(
            arn = javaType.arn(),
            associatePublicIpAddress = javaType.associatePublicIpAddress(),
            ebsBlockDevices = javaType.ebsBlockDevices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchConfigurationEbsBlockDevice.Companion.toKotlin(args0)
                })
            }),
            ebsOptimized = javaType.ebsOptimized(),
            enableMonitoring = javaType.enableMonitoring(),
            ephemeralBlockDevices = javaType.ephemeralBlockDevices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchConfigurationEphemeralBlockDevice.Companion.toKotlin(args0)
                })
            }),
            iamInstanceProfile = javaType.iamInstanceProfile(),
            id = javaType.id(),
            imageId = javaType.imageId(),
            instanceType = javaType.instanceType(),
            keyName = javaType.keyName(),
            metadataOptions = javaType.metadataOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchConfigurationMetadataOption.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            placementTenancy = javaType.placementTenancy(),
            rootBlockDevices = javaType.rootBlockDevices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchConfigurationRootBlockDevice.Companion.toKotlin(args0)
                })
            }),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            spotPrice = javaType.spotPrice(),
            userData = javaType.userData(),
        )
    }
}
