@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteOnTermination Whether the EBS Volume will be deleted on instance termination.
 * @property encrypted Whether the volume is Encrypted.
 * @property iops Provisioned IOPs of the volume.
 * @property throughput Throughput of the volume.
 * @property volumeSize Size of the volume.
 * @property volumeType Type of the volume.
 */
public data class GetLaunchConfigurationRootBlockDevice(
    public val deleteOnTermination: Boolean,
    public val encrypted: Boolean,
    public val iops: Int,
    public val throughput: Int,
    public val volumeSize: Int,
    public val volumeType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchConfigurationRootBlockDevice): GetLaunchConfigurationRootBlockDevice = GetLaunchConfigurationRootBlockDevice(
            deleteOnTermination = javaType.deleteOnTermination(),
            encrypted = javaType.encrypted(),
            iops = javaType.iops(),
            throughput = javaType.throughput(),
            volumeSize = javaType.volumeSize(),
            volumeType = javaType.volumeType(),
        )
    }
}
