@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property deviceName
 * @property ebs
 * @property noDevice
 * @property virtualName
 */
public data class GetLaunchTemplateBlockDeviceMapping(
    public val deviceName: String,
    public val ebs: List<GetLaunchTemplateBlockDeviceMappingEb>,
    public val noDevice: String,
    public val virtualName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchTemplateBlockDeviceMapping): GetLaunchTemplateBlockDeviceMapping = GetLaunchTemplateBlockDeviceMapping(
            deviceName = javaType.deviceName(),
            ebs = javaType.ebs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateBlockDeviceMappingEb.Companion.toKotlin(args0)
                })
            }),
            noDevice = javaType.noDevice(),
            virtualName = javaType.virtualName(),
        )
    }
}
