@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property acceleratorCounts
 * @property acceleratorManufacturers
 * @property acceleratorNames
 * @property acceleratorTotalMemoryMibs
 * @property acceleratorTypes
 * @property allowedInstanceTypes
 * @property bareMetal
 * @property baselineEbsBandwidthMbps
 * @property burstablePerformance
 * @property cpuManufacturers
 * @property excludedInstanceTypes
 * @property instanceGenerations
 * @property localStorage
 * @property localStorageTypes
 * @property maxSpotPriceAsPercentageOfOptimalOnDemandPrice
 * @property memoryGibPerVcpus
 * @property memoryMibs
 * @property networkBandwidthGbps
 * @property networkInterfaceCounts
 * @property onDemandMaxPricePercentageOverLowestPrice
 * @property requireHibernateSupport
 * @property spotMaxPricePercentageOverLowestPrice
 * @property totalLocalStorageGbs
 * @property vcpuCounts
 */
public data class GetLaunchTemplateInstanceRequirement(
    public val acceleratorCounts: List<GetLaunchTemplateInstanceRequirementAcceleratorCount>,
    public val acceleratorManufacturers: List<String>,
    public val acceleratorNames: List<String>,
    public val acceleratorTotalMemoryMibs: List<GetLaunchTemplateInstanceRequirementAcceleratorTotalMemoryMib>,
    public val acceleratorTypes: List<String>,
    public val allowedInstanceTypes: List<String>,
    public val bareMetal: String,
    public val baselineEbsBandwidthMbps: List<GetLaunchTemplateInstanceRequirementBaselineEbsBandwidthMbp>,
    public val burstablePerformance: String,
    public val cpuManufacturers: List<String>,
    public val excludedInstanceTypes: List<String>,
    public val instanceGenerations: List<String>,
    public val localStorage: String,
    public val localStorageTypes: List<String>,
    public val maxSpotPriceAsPercentageOfOptimalOnDemandPrice: Int,
    public val memoryGibPerVcpus: List<GetLaunchTemplateInstanceRequirementMemoryGibPerVcpus>,
    public val memoryMibs: List<GetLaunchTemplateInstanceRequirementMemoryMib>,
    public val networkBandwidthGbps: List<GetLaunchTemplateInstanceRequirementNetworkBandwidthGbp>,
    public val networkInterfaceCounts: List<GetLaunchTemplateInstanceRequirementNetworkInterfaceCount>,
    public val onDemandMaxPricePercentageOverLowestPrice: Int,
    public val requireHibernateSupport: Boolean,
    public val spotMaxPricePercentageOverLowestPrice: Int,
    public val totalLocalStorageGbs: List<GetLaunchTemplateInstanceRequirementTotalLocalStorageGb>,
    public val vcpuCounts: List<GetLaunchTemplateInstanceRequirementVcpuCount>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchTemplateInstanceRequirement): GetLaunchTemplateInstanceRequirement = GetLaunchTemplateInstanceRequirement(
            acceleratorCounts = javaType.acceleratorCounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceRequirementAcceleratorCount.Companion.toKotlin(args0)
                })
            }),
            acceleratorManufacturers = javaType.acceleratorManufacturers().map({ args0 -> args0 }),
            acceleratorNames = javaType.acceleratorNames().map({ args0 -> args0 }),
            acceleratorTotalMemoryMibs = javaType.acceleratorTotalMemoryMibs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceRequirementAcceleratorTotalMemoryMib.Companion.toKotlin(args0)
                })
            }),
            acceleratorTypes = javaType.acceleratorTypes().map({ args0 -> args0 }),
            allowedInstanceTypes = javaType.allowedInstanceTypes().map({ args0 -> args0 }),
            bareMetal = javaType.bareMetal(),
            baselineEbsBandwidthMbps = javaType.baselineEbsBandwidthMbps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceRequirementBaselineEbsBandwidthMbp.Companion.toKotlin(args0)
                })
            }),
            burstablePerformance = javaType.burstablePerformance(),
            cpuManufacturers = javaType.cpuManufacturers().map({ args0 -> args0 }),
            excludedInstanceTypes = javaType.excludedInstanceTypes().map({ args0 -> args0 }),
            instanceGenerations = javaType.instanceGenerations().map({ args0 -> args0 }),
            localStorage = javaType.localStorage(),
            localStorageTypes = javaType.localStorageTypes().map({ args0 -> args0 }),
            maxSpotPriceAsPercentageOfOptimalOnDemandPrice = javaType.maxSpotPriceAsPercentageOfOptimalOnDemandPrice(),
            memoryGibPerVcpus = javaType.memoryGibPerVcpus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceRequirementMemoryGibPerVcpus.Companion.toKotlin(args0)
                })
            }),
            memoryMibs = javaType.memoryMibs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceRequirementMemoryMib.Companion.toKotlin(args0)
                })
            }),
            networkBandwidthGbps = javaType.networkBandwidthGbps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceRequirementNetworkBandwidthGbp.Companion.toKotlin(args0)
                })
            }),
            networkInterfaceCounts = javaType.networkInterfaceCounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceRequirementNetworkInterfaceCount.Companion.toKotlin(args0)
                })
            }),
            onDemandMaxPricePercentageOverLowestPrice = javaType.onDemandMaxPricePercentageOverLowestPrice(),
            requireHibernateSupport = javaType.requireHibernateSupport(),
            spotMaxPricePercentageOverLowestPrice = javaType.spotMaxPricePercentageOverLowestPrice(),
            totalLocalStorageGbs = javaType.totalLocalStorageGbs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceRequirementTotalLocalStorageGb.Companion.toKotlin(args0)
                })
            }),
            vcpuCounts = javaType.vcpuCounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceRequirementVcpuCount.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
