@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpEndpoint
 * @property httpProtocolIpv6
 * @property httpPutResponseHopLimit
 * @property httpTokens
 * @property instanceMetadataTags
 */
public data class GetLaunchTemplateMetadataOption(
    public val httpEndpoint: String,
    public val httpProtocolIpv6: String,
    public val httpPutResponseHopLimit: Int,
    public val httpTokens: String,
    public val instanceMetadataTags: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchTemplateMetadataOption): GetLaunchTemplateMetadataOption = GetLaunchTemplateMetadataOption(
            httpEndpoint = javaType.httpEndpoint(),
            httpProtocolIpv6 = javaType.httpProtocolIpv6(),
            httpPutResponseHopLimit = javaType.httpPutResponseHopLimit(),
            httpTokens = javaType.httpTokens(),
            instanceMetadataTags = javaType.instanceMetadataTags(),
        )
    }
}
