@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property associateCarrierIpAddress
 * @property associatePublicIpAddress
 * @property deleteOnTermination
 * @property description
 * @property deviceIndex
 * @property interfaceType
 * @property ipv4AddressCount
 * @property ipv4Addresses
 * @property ipv4PrefixCount
 * @property ipv4Prefixes
 * @property ipv6AddressCount
 * @property ipv6Addresses
 * @property ipv6PrefixCount
 * @property ipv6Prefixes
 * @property networkCardIndex
 * @property networkInterfaceId
 * @property primaryIpv6
 * @property privateIpAddress
 * @property securityGroups
 * @property subnetId
 */
public data class GetLaunchTemplateNetworkInterface(
    public val associateCarrierIpAddress: String,
    public val associatePublicIpAddress: Boolean? = null,
    public val deleteOnTermination: Boolean? = null,
    public val description: String,
    public val deviceIndex: Int,
    public val interfaceType: String,
    public val ipv4AddressCount: Int,
    public val ipv4Addresses: List<String>,
    public val ipv4PrefixCount: Int,
    public val ipv4Prefixes: List<String>,
    public val ipv6AddressCount: Int,
    public val ipv6Addresses: List<String>,
    public val ipv6PrefixCount: Int,
    public val ipv6Prefixes: List<String>,
    public val networkCardIndex: Int,
    public val networkInterfaceId: String,
    public val primaryIpv6: String,
    public val privateIpAddress: String,
    public val securityGroups: List<String>,
    public val subnetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchTemplateNetworkInterface): GetLaunchTemplateNetworkInterface = GetLaunchTemplateNetworkInterface(
            associateCarrierIpAddress = javaType.associateCarrierIpAddress(),
            associatePublicIpAddress = javaType.associatePublicIpAddress().map({ args0 -> args0 }).orElse(null),
            deleteOnTermination = javaType.deleteOnTermination().map({ args0 -> args0 }).orElse(null),
            description = javaType.description(),
            deviceIndex = javaType.deviceIndex(),
            interfaceType = javaType.interfaceType(),
            ipv4AddressCount = javaType.ipv4AddressCount(),
            ipv4Addresses = javaType.ipv4Addresses().map({ args0 -> args0 }),
            ipv4PrefixCount = javaType.ipv4PrefixCount(),
            ipv4Prefixes = javaType.ipv4Prefixes().map({ args0 -> args0 }),
            ipv6AddressCount = javaType.ipv6AddressCount(),
            ipv6Addresses = javaType.ipv6Addresses().map({ args0 -> args0 }),
            ipv6PrefixCount = javaType.ipv6PrefixCount(),
            ipv6Prefixes = javaType.ipv6Prefixes().map({ args0 -> args0 }),
            networkCardIndex = javaType.networkCardIndex(),
            networkInterfaceId = javaType.networkInterfaceId(),
            primaryIpv6 = javaType.primaryIpv6(),
            privateIpAddress = javaType.privateIpAddress(),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            subnetId = javaType.subnetId(),
        )
    }
}
