@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property affinity
 * @property availabilityZone
 * @property groupName
 * @property hostId
 * @property hostResourceGroupArn
 * @property partitionNumber
 * @property spreadDomain
 * @property tenancy
 */
public data class GetLaunchTemplatePlacement(
    public val affinity: String,
    public val availabilityZone: String,
    public val groupName: String,
    public val hostId: String,
    public val hostResourceGroupArn: String,
    public val partitionNumber: Int,
    public val spreadDomain: String,
    public val tenancy: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchTemplatePlacement): GetLaunchTemplatePlacement = GetLaunchTemplatePlacement(
            affinity = javaType.affinity(),
            availabilityZone = javaType.availabilityZone(),
            groupName = javaType.groupName(),
            hostId = javaType.hostId(),
            hostResourceGroupArn = javaType.hostResourceGroupArn(),
            partitionNumber = javaType.partitionNumber(),
            spreadDomain = javaType.spreadDomain(),
            tenancy = javaType.tenancy(),
        )
    }
}
