@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLocalGateway.
 * @property filters
 * @property id
 * @property outpostArn ARN of Outpost
 * @property ownerId AWS account identifier that owns the Local Gateway.
 * @property state State of the local gateway.
 * @property tags
 */
public data class GetLocalGatewayResult(
    public val filters: List<GetLocalGatewayFilter>? = null,
    public val id: String,
    public val outpostArn: String,
    public val ownerId: String,
    public val state: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLocalGatewayResult): GetLocalGatewayResult = GetLocalGatewayResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            outpostArn = javaType.outpostArn(),
            ownerId = javaType.ownerId(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
