@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLocalGatewayRouteTable.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property localGatewayId
 * @property localGatewayRouteTableId
 * @property outpostArn
 * @property state
 * @property tags
 */
public data class GetLocalGatewayRouteTableResult(
    public val filters: List<GetLocalGatewayRouteTableFilter>? = null,
    public val id: String,
    public val localGatewayId: String,
    public val localGatewayRouteTableId: String,
    public val outpostArn: String,
    public val state: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLocalGatewayRouteTableResult): GetLocalGatewayRouteTableResult = GetLocalGatewayRouteTableResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayRouteTableFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            localGatewayId = javaType.localGatewayId(),
            localGatewayRouteTableId = javaType.localGatewayRouteTableId(),
            outpostArn = javaType.outpostArn(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
