@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getManagedPrefixList.
 * @property addressFamily Address family of the prefix list. Valid values are `IPv4` and `IPv6`.
 * @property arn ARN of the selected prefix list.
 * @property entries Set of entries in this prefix list. Each entry is an object with `cidr` and `description`.
 * @property filters
 * @property id ID of the selected prefix list.
 * @property maxEntries When then prefix list is managed, the maximum number of entries it supports, or null otherwise.
 * @property name Name of the selected prefix list.
 * @property ownerId Account ID of the owner of a customer-managed prefix list, or `AWS` otherwise.
 * @property tags Map of tags assigned to the resource.
 * @property version
 */
public data class GetManagedPrefixListResult(
    public val addressFamily: String,
    public val arn: String,
    public val entries: List<GetManagedPrefixListEntry>,
    public val filters: List<GetManagedPrefixListFilter>? = null,
    public val id: String,
    public val maxEntries: Int,
    public val name: String,
    public val ownerId: String,
    public val tags: Map<String, String>,
    public val version: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetManagedPrefixListResult): GetManagedPrefixListResult = GetManagedPrefixListResult(
            addressFamily = javaType.addressFamily(),
            arn = javaType.arn(),
            entries = javaType.entries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetManagedPrefixListEntry.Companion.toKotlin(args0)
                })
            }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetManagedPrefixListFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            maxEntries = javaType.maxEntries(),
            name = javaType.name(),
            ownerId = javaType.ownerId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            version = javaType.version(),
        )
    }
}
