@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getNatGateway.
 * @property allocationId ID of the EIP allocated to the selected NAT Gateway.
 * @property associationId The association ID of the Elastic IP address that's associated with the NAT Gateway. Only available when `connectivity_type` is `public`.
 * @property connectivityType Connectivity type of the NAT Gateway.
 * @property filters
 * @property id
 * @property networkInterfaceId The ID of the ENI allocated to the selected NAT Gateway.
 * @property privateIp Private IP address of the selected NAT Gateway.
 * @property publicIp Public IP (EIP) address of the selected NAT Gateway.
 * @property secondaryAllocationIds Secondary allocation EIP IDs for the selected NAT Gateway.
 * @property secondaryPrivateIpAddressCount The number of secondary private IPv4 addresses assigned to the selected NAT Gateway.
 * @property secondaryPrivateIpAddresses Secondary private IPv4 addresses assigned to the selected NAT Gateway.
 * @property state
 * @property subnetId
 * @property tags
 * @property vpcId
 */
public data class GetNatGatewayResult(
    public val allocationId: String,
    public val associationId: String,
    public val connectivityType: String,
    public val filters: List<GetNatGatewayFilter>? = null,
    public val id: String,
    public val networkInterfaceId: String,
    public val privateIp: String,
    public val publicIp: String,
    public val secondaryAllocationIds: List<String>,
    public val secondaryPrivateIpAddressCount: Int,
    public val secondaryPrivateIpAddresses: List<String>,
    public val state: String,
    public val subnetId: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetNatGatewayResult): GetNatGatewayResult = GetNatGatewayResult(
            allocationId = javaType.allocationId(),
            associationId = javaType.associationId(),
            connectivityType = javaType.connectivityType(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetNatGatewayFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            networkInterfaceId = javaType.networkInterfaceId(),
            privateIp = javaType.privateIp(),
            publicIp = javaType.publicIp(),
            secondaryAllocationIds = javaType.secondaryAllocationIds().map({ args0 -> args0 }),
            secondaryPrivateIpAddressCount = javaType.secondaryPrivateIpAddressCount(),
            secondaryPrivateIpAddresses = javaType.secondaryPrivateIpAddresses().map({ args0 -> args0 }),
            state = javaType.state(),
            subnetId = javaType.subnetId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
        )
    }
}
