@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn ARN of the selected Network Insights Analysis.
 * @property id
 * @property name Name of the filter field. Valid values can be found in the EC2 [`DescribeNetworkInsightsAnalyses`](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInsightsAnalyses.html) API Reference.
 */
public data class GetNetworkInsightsAnalysisForwardPathComponentDestinationVpc(
    public val arn: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetNetworkInsightsAnalysisForwardPathComponentDestinationVpc): GetNetworkInsightsAnalysisForwardPathComponentDestinationVpc =
            GetNetworkInsightsAnalysisForwardPathComponentDestinationVpc(
                arn = javaType.arn(),
                id = javaType.id(),
                name = javaType.name(),
            )
    }
}
