@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property destinationAddresses
 * @property destinationPortRanges
 * @property protocol
 * @property sourceAddresses
 * @property sourcePortRanges
 */
public data class GetNetworkInsightsAnalysisForwardPathComponentInboundHeader(
    public val destinationAddresses: List<String>,
    public val destinationPortRanges: List<GetNetworkInsightsAnalysisForwardPathComponentInboundHeaderDestinationPortRange>,
    public val protocol: String,
    public val sourceAddresses: List<String>,
    public val sourcePortRanges: List<GetNetworkInsightsAnalysisForwardPathComponentInboundHeaderSourcePortRange>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetNetworkInsightsAnalysisForwardPathComponentInboundHeader): GetNetworkInsightsAnalysisForwardPathComponentInboundHeader =
            GetNetworkInsightsAnalysisForwardPathComponentInboundHeader(
                destinationAddresses = javaType.destinationAddresses().map({ args0 -> args0 }),
                destinationPortRanges = javaType.destinationPortRanges().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentInboundHeaderDestinationPortRange.Companion.toKotlin(args0)
                    })
                }),
                protocol = javaType.protocol(),
                sourceAddresses = javaType.sourceAddresses().map({ args0 -> args0 }),
                sourcePortRanges = javaType.sourcePortRanges().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentInboundHeaderSourcePortRange.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
