@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cidr
 * @property direction
 * @property portRanges
 * @property prefixListId
 * @property protocol
 * @property securityGroupId
 */
public data class GetNetworkInsightsAnalysisReturnPathComponentSecurityGroupRule(
    public val cidr: String,
    public val direction: String,
    public val portRanges: List<GetNetworkInsightsAnalysisReturnPathComponentSecurityGroupRulePortRange>,
    public val prefixListId: String,
    public val protocol: String,
    public val securityGroupId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetNetworkInsightsAnalysisReturnPathComponentSecurityGroupRule): GetNetworkInsightsAnalysisReturnPathComponentSecurityGroupRule =
            GetNetworkInsightsAnalysisReturnPathComponentSecurityGroupRule(
                cidr = javaType.cidr(),
                direction = javaType.direction(),
                portRanges = javaType.portRanges().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentSecurityGroupRulePortRange.Companion.toKotlin(args0)
                    })
                }),
                prefixListId = javaType.prefixListId(),
                protocol = javaType.protocol(),
                securityGroupId = javaType.securityGroupId(),
            )
    }
}
