@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allocationId Allocation ID.
 * @property associationId Association ID.
 * @property carrierIp Carrier IP address associated with the network interface. This attribute is only set when the network interface is in a subnet which is associated with a Wavelength Zone.
 * @property customerOwnedIp Customer-owned IP address.
 * @property ipOwnerId ID of the Elastic IP address owner.
 * @property publicDnsName Public DNS name.
 * @property publicIp Address of the Elastic IP address bound to the network interface.
 */
public data class GetNetworkInterfaceAssociation(
    public val allocationId: String,
    public val associationId: String,
    public val carrierIp: String,
    public val customerOwnedIp: String,
    public val ipOwnerId: String,
    public val publicDnsName: String,
    public val publicIp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetNetworkInterfaceAssociation): GetNetworkInterfaceAssociation = GetNetworkInterfaceAssociation(
            allocationId = javaType.allocationId(),
            associationId = javaType.associationId(),
            carrierIp = javaType.carrierIp(),
            customerOwnedIp = javaType.customerOwnedIp(),
            ipOwnerId = javaType.ipOwnerId(),
            publicDnsName = javaType.publicDnsName(),
            publicIp = javaType.publicIp(),
        )
    }
}
