@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getPublicIpv4Pool.
 * @property description Description of the pool, if any.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property networkBorderGroup Name of the location from which the address pool is advertised.
 * * pool_address_ranges` - List of Address Ranges in the Pool; each address range record contains:
 * @property poolAddressRanges
 * @property poolId
 * @property tags Any tags for the address pool.
 * @property totalAddressCount Total number of addresses in the pool.
 * @property totalAvailableAddressCount Total number of available addresses in the pool.
 */
public data class GetPublicIpv4PoolResult(
    public val description: String,
    public val id: String,
    public val networkBorderGroup: String,
    public val poolAddressRanges: List<GetPublicIpv4PoolPoolAddressRange>,
    public val poolId: String,
    public val tags: Map<String, String>,
    public val totalAddressCount: Int,
    public val totalAvailableAddressCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetPublicIpv4PoolResult): GetPublicIpv4PoolResult = GetPublicIpv4PoolResult(
            description = javaType.description(),
            id = javaType.id(),
            networkBorderGroup = javaType.networkBorderGroup(),
            poolAddressRanges = javaType.poolAddressRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetPublicIpv4PoolPoolAddressRange.Companion.toKotlin(args0)
                })
            }),
            poolId = javaType.poolId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalAddressCount = javaType.totalAddressCount(),
            totalAvailableAddressCount = javaType.totalAvailableAddressCount(),
        )
    }
}
