@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getRoute.
 * @property carrierGatewayId
 * @property coreNetworkArn
 * @property destinationCidrBlock
 * @property destinationIpv6CidrBlock
 * @property destinationPrefixListId
 * @property egressOnlyGatewayId
 * @property gatewayId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property localGatewayId
 * @property natGatewayId
 * @property networkInterfaceId
 * @property routeTableId
 * @property transitGatewayId
 * @property vpcPeeringConnectionId
 */
public data class GetRouteResult(
    public val carrierGatewayId: String,
    public val coreNetworkArn: String,
    public val destinationCidrBlock: String,
    public val destinationIpv6CidrBlock: String,
    public val destinationPrefixListId: String,
    public val egressOnlyGatewayId: String,
    public val gatewayId: String,
    public val id: String,
    public val instanceId: String,
    public val localGatewayId: String,
    public val natGatewayId: String,
    public val networkInterfaceId: String,
    public val routeTableId: String,
    public val transitGatewayId: String,
    public val vpcPeeringConnectionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetRouteResult): GetRouteResult =
            GetRouteResult(
                carrierGatewayId = javaType.carrierGatewayId(),
                coreNetworkArn = javaType.coreNetworkArn(),
                destinationCidrBlock = javaType.destinationCidrBlock(),
                destinationIpv6CidrBlock = javaType.destinationIpv6CidrBlock(),
                destinationPrefixListId = javaType.destinationPrefixListId(),
                egressOnlyGatewayId = javaType.egressOnlyGatewayId(),
                gatewayId = javaType.gatewayId(),
                id = javaType.id(),
                instanceId = javaType.instanceId(),
                localGatewayId = javaType.localGatewayId(),
                natGatewayId = javaType.natGatewayId(),
                networkInterfaceId = javaType.networkInterfaceId(),
                routeTableId = javaType.routeTableId(),
                transitGatewayId = javaType.transitGatewayId(),
                vpcPeeringConnectionId = javaType.vpcPeeringConnectionId(),
            )
    }
}
