@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSecurityGroup.
 * @property arn Computed ARN of the security group.
 * @property description Description of the security group.
 * @property filters
 * @property id
 * @property name
 * @property tags
 * @property vpcId
 */
public data class GetSecurityGroupResult(
    public val arn: String,
    public val description: String,
    public val filters: List<GetSecurityGroupFilter>? = null,
    public val id: String,
    public val name: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetSecurityGroupResult): GetSecurityGroupResult = GetSecurityGroupResult(
            arn = javaType.arn(),
            description = javaType.description(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetSecurityGroupFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
        )
    }
}
