@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getSerialConsoleAccess.
 * @property enabled Whether or not serial console access is enabled. Returns as `true` or `false`.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetSerialConsoleAccessResult(
    public val enabled: Boolean,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetSerialConsoleAccessResult): GetSerialConsoleAccessResult = GetSerialConsoleAccessResult(
            enabled = javaType.enabled(),
            id = javaType.id(),
        )
    }
}
