@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSubnets.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids List of all the subnet ids found.
 * @property tags
 */
public data class GetSubnetsResult(
    public val filters: List<GetSubnetsFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetSubnetsResult): GetSubnetsResult =
            GetSubnetsResult(
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetSubnetsFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
