@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property associationId Association ID for the IPv4 CIDR block.
 * @property cidrBlock Cidr block of the desired VPC.
 * @property state Current state of the desired VPC.
 * Can be either `"pending"` or `"available"`.
 */
public data class GetVpcCidrBlockAssociation(
    public val associationId: String,
    public val cidrBlock: String,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpcCidrBlockAssociation): GetVpcCidrBlockAssociation = GetVpcCidrBlockAssociation(
            associationId = javaType.associationId(),
            cidrBlock = javaType.cidrBlock(),
            state = javaType.state(),
        )
    }
}
