@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dnsRecordIpType The DNS records created for the endpoint.
 * @property privateDnsOnlyForInboundResolverEndpoint Indicates whether to enable private DNS only for inbound endpoints.
 */
public data class GetVpcEndpointDnsOption(
    public val dnsRecordIpType: String,
    public val privateDnsOnlyForInboundResolverEndpoint: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpcEndpointDnsOption): GetVpcEndpointDnsOption = GetVpcEndpointDnsOption(
            dnsRecordIpType = javaType.dnsRecordIpType(),
            privateDnsOnlyForInboundResolverEndpoint = javaType.privateDnsOnlyForInboundResolverEndpoint(),
        )
    }
}
