@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property addressFamily IP protocol assigned to this pool.
 * @property allocationDefaultNetmaskLength A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is `10.0.0.0/8` and you enter 16 here, new allocations will default to `10.0.0.0/16`.
 * @property allocationMaxNetmaskLength The maximum netmask length that will be required for CIDR allocations in this pool.
 * @property allocationMinNetmaskLength The minimum netmask length that will be required for CIDR allocations in this pool.
 * @property allocationResourceTags Tags that are required to create resources in using this pool.
 * @property arn ARN of the pool
 * @property autoImport If enabled, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM.
 * @property awsService Limits which service in AWS that the pool can be used in. `ec2` for example, allows users to use space for Elastic IP addresses and VPCs.
 * @property description Description for the IPAM pool.
 * @property id ID of the IPAM pool.
 * @property ipamScopeId ID of the scope the pool belongs to.
 * @property ipamScopeType
 * @property locale Locale is the Region where your pool is available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region.
 * @property poolDepth
 * @property publiclyAdvertisable Defines whether or not IPv6 pool space is publicly advertisable over the internet.
 * @property sourceIpamPoolId ID of the source IPAM pool.
 * @property state
 * @property tags Map of tags to assigned to the resource.
 */
public data class GetVpcIamPoolsIpamPool(
    public val addressFamily: String,
    public val allocationDefaultNetmaskLength: Int,
    public val allocationMaxNetmaskLength: Int,
    public val allocationMinNetmaskLength: Int,
    public val allocationResourceTags: Map<String, String>,
    public val arn: String,
    public val autoImport: Boolean,
    public val awsService: String,
    public val description: String,
    public val id: String,
    public val ipamScopeId: String,
    public val ipamScopeType: String,
    public val locale: String,
    public val poolDepth: Int,
    public val publiclyAdvertisable: Boolean,
    public val sourceIpamPoolId: String,
    public val state: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpcIamPoolsIpamPool): GetVpcIamPoolsIpamPool = GetVpcIamPoolsIpamPool(
            addressFamily = javaType.addressFamily(),
            allocationDefaultNetmaskLength = javaType.allocationDefaultNetmaskLength(),
            allocationMaxNetmaskLength = javaType.allocationMaxNetmaskLength(),
            allocationMinNetmaskLength = javaType.allocationMinNetmaskLength(),
            allocationResourceTags = javaType.allocationResourceTags().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            arn = javaType.arn(),
            autoImport = javaType.autoImport(),
            awsService = javaType.awsService(),
            description = javaType.description(),
            id = javaType.id(),
            ipamScopeId = javaType.ipamScopeId(),
            ipamScopeType = javaType.ipamScopeType(),
            locale = javaType.locale(),
            poolDepth = javaType.poolDepth(),
            publiclyAdvertisable = javaType.publiclyAdvertisable(),
            sourceIpamPoolId = javaType.sourceIpamPoolId(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
