@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name The name of the filter. Filter names are case-sensitive.
 * @property values The filter values. Filter values are case-sensitive.
 */
public data class GetVpcIpamPoolFilter(
    public val name: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpcIpamPoolFilter): GetVpcIpamPoolFilter = GetVpcIpamPoolFilter(
            name = javaType.name(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
