@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVpc.
 * @property arn ARN of VPC
 * @property cidrBlock CIDR block for the association.
 * @property cidrBlockAssociations
 * @property default
 * @property dhcpOptionsId
 * @property enableDnsHostnames Whether or not the VPC has DNS hostname support
 * @property enableDnsSupport Whether or not the VPC has DNS support
 * @property enableNetworkAddressUsageMetrics Whether Network Address Usage metrics are enabled for your VPC
 * @property filters
 * @property id
 * @property instanceTenancy Allowed tenancy of instances launched into the
 * selected VPC. May be any of `"default"`, `"dedicated"`, or `"host"`.
 * @property ipv6AssociationId Association ID for the IPv6 CIDR block.
 * @property ipv6CidrBlock IPv6 CIDR block.
 * @property mainRouteTableId ID of the main route table associated with this VPC.
 * @property ownerId ID of the AWS account that owns the VPC.
 * @property state State of the association.
 * @property tags
 */
public data class GetVpcResult(
    public val arn: String,
    public val cidrBlock: String,
    public val cidrBlockAssociations: List<GetVpcCidrBlockAssociation>,
    public val default: Boolean,
    public val dhcpOptionsId: String,
    public val enableDnsHostnames: Boolean,
    public val enableDnsSupport: Boolean,
    public val enableNetworkAddressUsageMetrics: Boolean,
    public val filters: List<GetVpcFilter>? = null,
    public val id: String,
    public val instanceTenancy: String,
    public val ipv6AssociationId: String,
    public val ipv6CidrBlock: String,
    public val mainRouteTableId: String,
    public val ownerId: String,
    public val state: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpcResult): GetVpcResult =
            GetVpcResult(
                arn = javaType.arn(),
                cidrBlock = javaType.cidrBlock(),
                cidrBlockAssociations = javaType.cidrBlockAssociations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetVpcCidrBlockAssociation.Companion.toKotlin(args0)
                    })
                }),
                default = javaType.default_(),
                dhcpOptionsId = javaType.dhcpOptionsId(),
                enableDnsHostnames = javaType.enableDnsHostnames(),
                enableDnsSupport = javaType.enableDnsSupport(),
                enableNetworkAddressUsageMetrics = javaType.enableNetworkAddressUsageMetrics(),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetVpcFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                instanceTenancy = javaType.instanceTenancy(),
                ipv6AssociationId = javaType.ipv6AssociationId(),
                ipv6CidrBlock = javaType.ipv6CidrBlock(),
                mainRouteTableId = javaType.mainRouteTableId(),
                ownerId = javaType.ownerId(),
                state = javaType.state(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
