@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceInterruptionBehavior The behavior when a Spot Instance is interrupted. Valid values include `hibernate`, `stop`, `terminate` . The default is `terminate`.
 * @property maxPrice The maximum hourly price that you're willing to pay for a Spot Instance.
 * @property spotInstanceType The Spot Instance request type. Valid values include `one-time`, `persistent`. Persistent Spot Instance requests are only supported when the instance interruption behavior is either hibernate or stop. The default is `one-time`.
 * @property validUntil The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ). Supported only for persistent requests.
 */
public data class InstanceInstanceMarketOptionsSpotOptions(
    public val instanceInterruptionBehavior: String? = null,
    public val maxPrice: String? = null,
    public val spotInstanceType: String? = null,
    public val validUntil: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.InstanceInstanceMarketOptionsSpotOptions): InstanceInstanceMarketOptionsSpotOptions = InstanceInstanceMarketOptionsSpotOptions(
            instanceInterruptionBehavior = javaType.instanceInterruptionBehavior().map({ args0 ->
                args0
            }).orElse(null),
            maxPrice = javaType.maxPrice().map({ args0 -> args0 }).orElse(null),
            spotInstanceType = javaType.spotInstanceType().map({ args0 -> args0 }).orElse(null),
            validUntil = javaType.validUntil().map({ args0 -> args0 }).orElse(null),
        )
    }
}
