@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteOnTermination Whether or not to delete the network interface on instance termination. Defaults to `false`. Currently, the only valid value is `false`, as this is only supported when creating new network interfaces when launching an instance.
 * @property deviceIndex Integer index of the network interface attachment. Limited by instance type.
 * @property networkCardIndex Integer index of the network card. Limited by instance type. The default index is `0`.
 * @property networkInterfaceId ID of the network interface to attach.
 */
public data class InstanceNetworkInterface(
    public val deleteOnTermination: Boolean? = null,
    public val deviceIndex: Int,
    public val networkCardIndex: Int? = null,
    public val networkInterfaceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.InstanceNetworkInterface): InstanceNetworkInterface = InstanceNetworkInterface(
            deleteOnTermination = javaType.deleteOnTermination().map({ args0 -> args0 }).orElse(null),
            deviceIndex = javaType.deviceIndex(),
            networkCardIndex = javaType.networkCardIndex().map({ args0 -> args0 }).orElse(null),
            networkInterfaceId = javaType.networkInterfaceId(),
        )
    }
}
