@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deviceName
 * @property noDevice
 * @property virtualName
 */
public data class LaunchConfigurationEphemeralBlockDevice(
    public val deviceName: String,
    public val noDevice: Boolean? = null,
    public val virtualName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchConfigurationEphemeralBlockDevice): LaunchConfigurationEphemeralBlockDevice = LaunchConfigurationEphemeralBlockDevice(
            deviceName = javaType.deviceName(),
            noDevice = javaType.noDevice().map({ args0 -> args0 }).orElse(null),
            virtualName = javaType.virtualName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
