@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpEndpoint The state of the metadata service: `enabled`, `disabled`.
 * @property httpPutResponseHopLimit The desired HTTP PUT response hop limit for instance metadata requests.
 * @property httpTokens If session tokens are required: `optional`, `required`.
 */
public data class LaunchConfigurationMetadataOptions(
    public val httpEndpoint: String? = null,
    public val httpPutResponseHopLimit: Int? = null,
    public val httpTokens: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchConfigurationMetadataOptions): LaunchConfigurationMetadataOptions = LaunchConfigurationMetadataOptions(
            httpEndpoint = javaType.httpEndpoint().map({ args0 -> args0 }).orElse(null),
            httpPutResponseHopLimit = javaType.httpPutResponseHopLimit().map({ args0 -> args0 }).orElse(null),
            httpTokens = javaType.httpTokens().map({ args0 -> args0 }).orElse(null),
        )
    }
}
