@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deviceName The name of the device to mount.
 * @property ebs Configure EBS volume properties.
 * @property noDevice Suppresses the specified device included in the AMI's block device mapping.
 * @property virtualName The [Instance Store Device
 * Name](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames)
 * (e.g., `"ephemeral0"`).
 */
public data class LaunchTemplateBlockDeviceMapping(
    public val deviceName: String? = null,
    public val ebs: LaunchTemplateBlockDeviceMappingEbs? = null,
    public val noDevice: String? = null,
    public val virtualName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateBlockDeviceMapping): LaunchTemplateBlockDeviceMapping = LaunchTemplateBlockDeviceMapping(
            deviceName = javaType.deviceName().map({ args0 -> args0 }).orElse(null),
            ebs = javaType.ebs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateBlockDeviceMappingEbs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            noDevice = javaType.noDevice().map({ args0 -> args0 }).orElse(null),
            virtualName = javaType.virtualName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
