@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property capacityReservationPreference Indicates the instance's Capacity Reservation preferences. Can be `open` or `none`. (Default `none`).
 * @property capacityReservationTarget Used to target a specific Capacity Reservation:
 */
public data class LaunchTemplateCapacityReservationSpecification(
    public val capacityReservationPreference: String? = null,
    public val capacityReservationTarget: LaunchTemplateCapacityReservationSpecificationCapacityReservationTarget? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateCapacityReservationSpecification): LaunchTemplateCapacityReservationSpecification =
            LaunchTemplateCapacityReservationSpecification(
                capacityReservationPreference = javaType.capacityReservationPreference().map({ args0 ->
                    args0
                }).orElse(null),
                capacityReservationTarget = javaType.capacityReservationTarget().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateCapacityReservationSpecificationCapacityReservationTarget.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
