@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property amdSevSnp Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a instance types only. Valid values are `enabled` and `disabled`.
 * @property coreCount The number of CPU cores for the instance.
 * @property threadsPerCore The number of threads per CPU core.
 * To disable Intel Hyper-Threading Technology for the instance, specify a value of 1.
 * Otherwise, specify the default value of 2.
 * Both number of CPU cores and threads per core must be specified. Valid number of CPU cores and threads per core for the instance type can be found in the [CPU Options Documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html?shortFooter=true#cpu-options-supported-instances-values)
 */
public data class LaunchTemplateCpuOptions(
    public val amdSevSnp: String? = null,
    public val coreCount: Int? = null,
    public val threadsPerCore: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateCpuOptions): LaunchTemplateCpuOptions = LaunchTemplateCpuOptions(
            amdSevSnp = javaType.amdSevSnp().map({ args0 -> args0 }).orElse(null),
            coreCount = javaType.coreCount().map({ args0 -> args0 }).orElse(null),
            threadsPerCore = javaType.threadsPerCore().map({ args0 -> args0 }).orElse(null),
        )
    }
}
