@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enabled If set to `true`, Nitro Enclaves will be enabled on the instance.
 * For more information, see the documentation on [Nitro Enclaves](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html).
 */
public data class LaunchTemplateEnclaveOptions(
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateEnclaveOptions): LaunchTemplateEnclaveOptions = LaunchTemplateEnclaveOptions(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
