@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the instance profile. Conflicts with `name`.
 * @property name The name of the instance profile.
 */
public data class LaunchTemplateIamInstanceProfile(
    public val arn: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateIamInstanceProfile): LaunchTemplateIamInstanceProfile = LaunchTemplateIamInstanceProfile(
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
