@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property marketType The market type. Can be `spot`.
 * @property spotOptions The options for [Spot Instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html)
 */
public data class LaunchTemplateInstanceMarketOptions(
    public val marketType: String? = null,
    public val spotOptions: LaunchTemplateInstanceMarketOptionsSpotOptions? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateInstanceMarketOptions): LaunchTemplateInstanceMarketOptions = LaunchTemplateInstanceMarketOptions(
            marketType = javaType.marketType().map({ args0 -> args0 }).orElse(null),
            spotOptions = javaType.spotOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateInstanceMarketOptionsSpotOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
