@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property associateCarrierIpAddress Associate a Carrier IP address with `eth0` for a new network interface.
 * Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface.
 * Boolean value, can be left unset.
 * @property associatePublicIpAddress Associate a public ip address with the network interface.
 * Boolean value, can be left unset.
 * @property deleteOnTermination Whether the network interface should be destroyed on instance termination.
 * @property description Description of the network interface.
 * @property deviceIndex The integer index of the network interface attachment.
 * @property interfaceType The type of network interface. To create an Elastic Fabric Adapter (EFA), specify `efa`.
 * @property ipv4AddressCount The number of secondary private IPv4 addresses to assign to a network interface. Conflicts with `ipv4_addresses`
 * @property ipv4Addresses One or more private IPv4 addresses to associate. Conflicts with `ipv4_address_count`
 * @property ipv4PrefixCount The number of IPv4 prefixes to be automatically assigned to the network interface. Conflicts with `ipv4_prefixes`
 * @property ipv4Prefixes One or more IPv4 prefixes to be assigned to the network interface. Conflicts with `ipv4_prefix_count`
 * @property ipv6AddressCount The number of IPv6 addresses to assign to a network interface. Conflicts with `ipv6_addresses`
 * @property ipv6Addresses One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Conflicts with `ipv6_address_count`
 * @property ipv6PrefixCount The number of IPv6 prefixes to be automatically assigned to the network interface. Conflicts with `ipv6_prefixes`
 * @property ipv6Prefixes One or more IPv6 prefixes to be assigned to the network interface. Conflicts with `ipv6_prefix_count`
 * @property networkCardIndex The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.
 * @property networkInterfaceId The ID of the network interface to attach.
 * @property primaryIpv6
 * @property privateIpAddress The primary private IPv4 address.
 * @property securityGroups A list of security group IDs to associate.
 * @property subnetId The VPC Subnet ID to associate.
 */
public data class LaunchTemplateNetworkInterface(
    public val associateCarrierIpAddress: String? = null,
    public val associatePublicIpAddress: String? = null,
    public val deleteOnTermination: String? = null,
    public val description: String? = null,
    public val deviceIndex: Int? = null,
    public val interfaceType: String? = null,
    public val ipv4AddressCount: Int? = null,
    public val ipv4Addresses: List<String>? = null,
    public val ipv4PrefixCount: Int? = null,
    public val ipv4Prefixes: List<String>? = null,
    public val ipv6AddressCount: Int? = null,
    public val ipv6Addresses: List<String>? = null,
    public val ipv6PrefixCount: Int? = null,
    public val ipv6Prefixes: List<String>? = null,
    public val networkCardIndex: Int? = null,
    public val networkInterfaceId: String? = null,
    public val primaryIpv6: String? = null,
    public val privateIpAddress: String? = null,
    public val securityGroups: List<String>? = null,
    public val subnetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateNetworkInterface): LaunchTemplateNetworkInterface = LaunchTemplateNetworkInterface(
            associateCarrierIpAddress = javaType.associateCarrierIpAddress().map({ args0 ->
                args0
            }).orElse(null),
            associatePublicIpAddress = javaType.associatePublicIpAddress().map({ args0 -> args0 }).orElse(null),
            deleteOnTermination = javaType.deleteOnTermination().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            deviceIndex = javaType.deviceIndex().map({ args0 -> args0 }).orElse(null),
            interfaceType = javaType.interfaceType().map({ args0 -> args0 }).orElse(null),
            ipv4AddressCount = javaType.ipv4AddressCount().map({ args0 -> args0 }).orElse(null),
            ipv4Addresses = javaType.ipv4Addresses().map({ args0 -> args0 }),
            ipv4PrefixCount = javaType.ipv4PrefixCount().map({ args0 -> args0 }).orElse(null),
            ipv4Prefixes = javaType.ipv4Prefixes().map({ args0 -> args0 }),
            ipv6AddressCount = javaType.ipv6AddressCount().map({ args0 -> args0 }).orElse(null),
            ipv6Addresses = javaType.ipv6Addresses().map({ args0 -> args0 }),
            ipv6PrefixCount = javaType.ipv6PrefixCount().map({ args0 -> args0 }).orElse(null),
            ipv6Prefixes = javaType.ipv6Prefixes().map({ args0 -> args0 }),
            networkCardIndex = javaType.networkCardIndex().map({ args0 -> args0 }).orElse(null),
            networkInterfaceId = javaType.networkInterfaceId().map({ args0 -> args0 }).orElse(null),
            primaryIpv6 = javaType.primaryIpv6().map({ args0 -> args0 }).orElse(null),
            privateIpAddress = javaType.privateIpAddress().map({ args0 -> args0 }).orElse(null),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
